/*:
 * @target MZ
 * @plugindesc Ersetzt das ESC-Menü mit einem minimalistischen Menü (Optionen, Speichern, Hauptmenü, Spiel beenden) zentriert mit mehr Abstand nach unten.
 * @author YuiNya
 *
 * @help
 * Dieses Plugin ersetzt Scene_Menu durch Scene_LiteMenu, ohne SceneManager.push zu überschreiben.
 */

(() => {
  const _Scene_Boot_start = Scene_Boot.prototype.start;
  Scene_Boot.prototype.start = function() {
    _Scene_Boot_start.call(this);
    SceneManager._sceneClass = Scene_LiteMenu;
  };

  Scene_LiteMenu = class extends Scene_MenuBase {
    create() {
      super.create();
      this.createCommandWindow();
    }

    createCommandWindow() {
      const width = 360;
      const height = 4 * 48 + 36; // Höhe großzügiger für bessere Zeilenabstände
      const x = (Graphics.boxWidth - width) / 2;
      const y = (Graphics.boxHeight - height) / 2 + 60; // weiter nach unten versetzt
      this._commandWindow = new Window_LiteMenuCommand(x, y, width, height);
      this._commandWindow.setHandler("options", this.commandOptions.bind(this));
      this._commandWindow.setHandler("save", this.commandSave.bind(this));
      this._commandWindow.setHandler("title", this.commandToTitle.bind(this));
      this._commandWindow.setHandler("cancel", this.popScene.bind(this));
      this._commandWindow.setHandler("exit", this.commandExit.bind(this));
      this.addWindow(this._commandWindow);
    }

    commandOptions() {
      SceneManager.push(Scene_Options);
    }

    commandSave() {
      if ($gameSystem.isSaveEnabled()) {
        SceneManager.push(Scene_Save);
      }
    }

    commandToTitle() {
      SceneManager.goto(Scene_Title);
    }

    commandExit() {
      SceneManager.exit();
    }
  };

  class Window_LiteMenuCommand extends Window_Command {
    constructor(x, y, width, height) {
      super(new Rectangle(x, y, width, height));
    }

    makeCommandList() {
      this.addCommand("Optionen", "options");
      this.addCommand("Speichern", "save", this.isSaveEnabled());
      this.addCommand("Zurück zum Hauptmenü", "title");
      this.addCommand("Spiel beenden", "exit");
    }

    isSaveEnabled() {
      return $gameSystem.isSaveEnabled();
    }
  }

  Scene_Menu = Scene_LiteMenu;
})();
